                
-- Simple Elevator Simulation Program
--
-- By Arthur V. Lopes - (C) 1993 - The George Washington University

WITH Elevator_Simulation;
WITH Screen_IO;  Use Screen_IO;
WITH Random; USE Random;
WITH Text_IO; USE Text_IO;
PROCEDURE Run_Elevator_System IS

    No_Elevators      : CONSTANT Natural := 2;
    Elevator_Capacity : CONSTANT Natural := 8;
    No_Floors         : CONSTANT Natural := 9;
    No_Passengers     : CONSTANT Natural := 32;

    PACKAGE This_Elevator_System IS NEW Elevator_Simulation
        (No_Elevators, Elevator_Capacity, No_Floors, No_Passengers);
    USE This_Elevator_System;
 
BEGIN
    --ClearScreen;
    IF No_Floors > 9 OR No_Elevators > 6 OR Elevator_Capacity > 9 THEN
        Put_Line("Invalid Elevator_Simulation Generic Instantiation!");
        Put_Line("   First parameter's range is 1..6");
        Put_Line("   Secong parameter's range is 1..9");
        Put_Line("   Third parameter's range is 1..9");
        return;
    END IF;
    Set_Seed(Floor_Type'LAST / 2);
    Terminal.WriteAt(Where => (1,1), What => "                Passengers");
    Terminal.WriteAt(Where => (2,1), What => "At Floor :");
    Terminal.WriteAt(Where => (3,1), What => "Going to :");
    Terminal.WriteAt(Where => (5,1), What => "At Floor :");
    FOR I IN 1..No_Floors LOOP
        Terminal.WriteAt(Where => (5, I * 2 + 14), What => Integer'IMAGE(I));
    END LOOP;
    -- Start Elevators
    Control.Start;
    Control.Open_Doors_Building;    
    Control.Shut_Down;
    Terminal.WriteAt(Where => (1,10), 
                     What => "Average waiting time : " 
                             & Integer'IMAGE (Total_Wait_Time / No_Passengers));
END Run_Elevator_System;

